!Object constantsFor: 'Geos Libraries'!

geosLIB67 'SYSTEM\smsend'! !

!Object constantsFor: 'Geos vardata'!

attrSmacReplyActivated 28160!
attrSmacMultiselectEnabled 28164!
!

!Object constantsFor: 'Geos messages'!

manualDialing 28160!
contactSelected 28161!
recentNumberSelected 28162!
cancel 28163!
msdCancel 28164!
multipleContactsSelected 28165!
multipleRecentNumberSelected 28166!
addRecipient 28167!
changeSimView 28168!
changeDeviceMemory 28169!
multipleSimContactsSelected 28170!
openSendOptionsDialog 28171!
!

!Geos class methodsFor: 'library calls'!

!

MailboxAddressControl subclass: #SMAddressControl
	instanceVariableNames: ''
	classVariableNames: ''!

!SMAddressControl comment!
Library smsend, file internal/resp/smsend.goh! !

!SMAddressControl class methodsFor: 'library linkage'!

library
	^67!

entry
	^0000!
!

!SMAddressControl methodsFor: 'Geos instance variables'!

smaciDocInfo
	"@instance DocumentInfo SMACI_docInfo"
	^GCSDocumentInfo forPointer: (self ptrAt: 37).!

smaciDocInfo: aBlock
	"@instance DocumentInfo SMACI_docInfo"
	aBlock value: (GCSDocumentInfo forPointer: (self ptrAt: 37)).!

smaciPostcard
	"@instance ChunkHandle SMACI_postcard"
	^self wordAt: 75!

smaciPostcard: value
	"@instance ChunkHandle SMACI_postcard"
	^self wordAt: 75 put: value!

smaciTransaction
	"@instance optr SMACI_transaction"
	^self dwordAt: 77!

smaciTransaction: value
	"@instance optr SMACI_transaction"
	^self dwordAt: 77 put: value!

smaciAddressBlock
	"@instance MemHandle SMACI_addressBlock"
	^self wordAt: 81!

smaciAddressBlock: value
	"@instance MemHandle SMACI_addressBlock"
	^self wordAt: 81 put: value!

smaciNumAddresses
	"@instance word SMACI_numAddresses"
	^self wordAt: 83!

smaciNumAddresses: value
	"@instance word SMACI_numAddresses"
	^self wordAt: 83 put: value!

smaciAddressSelectedFrom
	"@instance byte SMACI_addressSelectedFrom"
	^self byteAt: 85!

smaciAddressSelectedFrom: value
	"@instance byte SMACI_addressSelectedFrom"
	^self byteAt: 85 put: value!

!

!SMAddressControl methodsFor: 'Geos vardata'!

attrSmacReplyActivated
	"@vardata void ATTR_SMAC_REPLY_ACTIVATED"
	^self addVardata: ##attrSmacReplyActivated!

attrSmacMultiselectEnabled
	"@vardata void ATTR_SMAC_MULTISELECT_ENABLED"
	^self addVardata: ##attrSmacMultiselectEnabled!

!

!SMAddressControl methodsFor: 'Geos messages'!

manualDialing
	"@message void MSG_SMAC_MANUAL_DIALING()"
	^self geosMessage: #[110 0 2 0 0]!

contactSelected: recordID with: fieldID
	"@message void MSG_SMAC_CONTACT_SELECTED( dword recordID = cx:dx, word fieldID = bp)"
	^self geosMessage: #[110 1 3 245 2 1 0] with: recordID with: fieldID!

recentNumberSelected: data
	"@message void MSG_SMAC_RECENT_NUMBER_SELECTED( RecentContactsData *data = ss:bp)"
	^self geosMessage: #[110 2 0 128 3 0] with: data!

cancel
	"@message void MSG_SMAC_CANCEL()"
	^self geosMessage: #[110 3 2 0 0]!

msdCancel
	"@message void MSG_SMAC_MSD_CANCEL()"
	^self geosMessage: #[110 4 2 0 0]!

multipleContactsSelected: block with: num
	"@message void MSG_SMAC_MULTIPLE_CONTACTS_SELECTED( MemHandle block = cx, word num = dx)"
	^self geosMessage: #[110 5 2 53 1 1 0] with: block with: num!

multipleRecentNumberSelected: block with: count
	"@message void MSG_SMAC_MULTIPLE_RECENT_NUMBER_SELECTED( MemHandle block = cx, word count = dx)"
	^self geosMessage: #[110 6 2 53 1 1 0] with: block with: count!

addRecipient
	"@message void MSG_SMAC_ADD_RECIPIENT()"
	^self geosMessage: #[110 7 2 0 0]!

changeSimView
	"@message void MSG_SMAC_CHANGE_SIM_VIEW()"
	^self geosMessage: #[110 8 2 0 0]!

changeDeviceMemory
	"@message void MSG_SMAC_CHANGE_DEVICE_MEMORY()"
	^self geosMessage: #[110 9 2 0 0]!

multipleSimContactsSelected: block with: num
	"@message void MSG_SMAC_MULTIPLE_SIM_CONTACTS_SELECTED( MemHandle block = cx, word num = dx)"
	^self geosMessage: #[110 10 2 53 1 1 0] with: block with: num!

openSendOptionsDialog
	"@message void MSG_SMAC_OPEN_SEND_OPTIONS_DIALOG()"
	^self geosMessage: #[110 11 2 0 0]!

!

